/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.internal.contentassist;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalComparator;
import com.aptana.editor.ruby.RubyEditorPlugin;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import com.aptana.ruby.core.IRubyMethod;
import com.aptana.ruby.core.ast.ASTUtils;
import com.aptana.ruby.core.ast.ClosestSpanningNodeLocator;
import com.aptana.ruby.core.ast.INodeAcceptor;
import com.aptana.ruby.core.ast.ScopedNodeLocator;
import com.aptana.ruby.core.codeassist.CompletionContext;
import com.aptana.ruby.core.index.RubyIndexUtil;
import com.aptana.ruby.core.inference.ITypeGuess;
import com.aptana.scripting.model.ContentAssistElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.HippieProposalProcessor;
import org.jruby.Ruby;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.RootNode;

public class RubyContentAssistProcessor
extends CommonContentAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final String NAMESPACE_DELIMITER = "::";
    private static final String GLOBAL_IMAGE = "icons/global_obj.png";
    private static final String INSTANCE_VAR_IMAGE = "icons/instance_var_obj.png";
    private static final String CLASS_VAR_IMAGE = "icons/class_var_obj.png";
    private static final String LOCAL_VAR_IMAGE = "icons/local_var_obj.png";
    private static final String CLASS_IMAGE = "icons/class_obj.png";
    private static final String MODULE_IMAGE = "icons/module_obj.png";
    private static final String PUBLIC_METHOD_IMAGE = "icons/method_public_obj.png";
    private static final String PROTECTED_METHOD_IMAGE = "icons/method_protected_obj.png";
    private static final String PRIVATE_METHOD_IMAGE = "icons/method_private_obj.png";
    private static final String CONSTANT_IMAGE = "icons/constant_obj.png";
    private static final String SYMBOL_IMAGE = "icons/global_obj.png";
    private static final String CALC_SUPER_TYPE_EVENT = "com.aptana.editor.ruby/perf/content_assist/calc_hierarchy";
    private static final String METHOD_PROPOSALS_FOR_TYPE_EVENT = "com.aptana.editor.ruby/perf/content_assist/type_methods";
    private static final String[] KEYWORDS = new String[]{"alias", "and", "BEGIN", "begin", "break", "case", "class", "def", "defined", "do", "else", "elsif", "END", "end", "ensure", "false", "for", "if", "in", "module", "next", "nil", "not", "or", "redo", "rescue", "retry", "return", "self", "super", "then", "true", "undef", "unless", "until", "when", "while", "yield"};
    private CompletionContext fContext;

    public RubyContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    protected Collection<? extends ICompletionProposal> addRubleCAProposals(ITextViewer viewer, int offset, Ruby ruby, ContentAssistElement ce) {
        if ("Type Inference code assist".equals(ce.getDisplayName())) {
            return Collections.emptyList();
        }
        return super.addRubleCAProposals(viewer, offset, ruby, ce);
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        this.fContext = this.createCompletionContext(viewer, offset);
        try {
            if (this.fContext.inComment()) {
                ICompletionProposal[] iCompletionProposalArray = NO_PROPOSALS;
                return iCompletionProposalArray;
            }
            if (this.fContext.isSymbol()) {
                proposals.addAll(this.suggestSymbols());
            } else if (this.fContext.isNotParseable()) {
                proposals.addAll(this.suggestKeywords());
            } else if (this.fContext.emptyPrefix()) {
                proposals.addAll(this.suggestLocalVariables());
                proposals.addAll(this.suggestInstanceVariables());
                proposals.addAll(this.suggestClassVariables());
                proposals.addAll(this.suggestMethodsForEnclosingType());
            } else if (this.fContext.isConstant()) {
                proposals.addAll(this.suggestConstantsInNamespace());
                proposals.addAll(this.suggestTypeNames());
            } else if (this.fContext.isGlobal()) {
                proposals.addAll(this.suggestGlobals());
            } else if (this.fContext.isInstanceVariable()) {
                proposals.addAll(this.suggestInstanceVariables());
            } else if (this.fContext.isClassVariable()) {
                proposals.addAll(this.suggestClassVariables());
            } else if (this.fContext.isInstanceOrClassVariable()) {
                proposals.addAll(this.suggestInstanceVariables());
                proposals.addAll(this.suggestClassVariables());
            } else if (this.fContext.isDoubleColon()) {
                if (this.fContext.getPartialPrefix().length() == 0 || Character.isUpperCase(this.fContext.getPartialPrefix().charAt(0))) {
                    proposals.addAll(this.suggestTypesInNamespace());
                    proposals.addAll(this.suggestConstantsInNamespace());
                }
                proposals.addAll(this.suggestMethodsOnReceiver());
            } else if (this.fContext.isExplicitMethodInvokation()) {
                proposals.addAll(this.suggestMethodsOnReceiver());
            } else if (this.fContext.isMethodInvokationOrLocal()) {
                proposals.addAll(this.suggestKeywords());
                proposals.addAll(this.suggestLocalVariables());
                proposals.addAll(this.suggestMethodsForEnclosingType());
                Collection<? extends ICompletionProposal> wordCompletions = this.suggestWordCompletions(viewer, offset);
                wordCompletions = this.removeDuplicates(proposals, wordCompletions);
                proposals.addAll(wordCompletions);
            }
            this.sortByDisplayName(proposals);
            ICompletionProposal[] iCompletionProposalArray = proposals.toArray(new ICompletionProposal[proposals.size()]);
            return iCompletionProposalArray;
        }
        finally {
            this.fContext = null;
        }
    }

    protected CompletionContext createCompletionContext(ITextViewer viewer, int offset) {
        return new CompletionContext(this.getProject(), viewer.getDocument().get(), offset - 1);
    }

    private Collection<? extends ICompletionProposal> suggestMethodsOnReceiver() {
        boolean receiverIsType;
        ArrayList<Object> proposals = new ArrayList<Object>();
        Collection guesses = this.fContext.inferReceiver();
        HashMap<String, Boolean> typeNames = new HashMap<String, Boolean>();
        HashSet<String> receiverTypes = new HashSet<String>();
        for (ITypeGuess guess : guesses) {
            String typeName = guess.getType();
            receiverTypes.add(typeName);
            typeNames.put(typeName, guess.isModule());
            typeNames.putAll(this.calculateSuperTypes(typeName));
        }
        proposals.addAll(this.suggestMethodsForTypes(receiverTypes, typeNames, receiverIsType, !(receiverIsType = this.receiverIsType()), receiverIsType, receiverIsType));
        if (receiverIsType) {
            proposals.add(this.createProposal("new", RubyEditorPlugin.getImage(PUBLIC_METHOD_IMAGE)));
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> suggestKeywords() {
        ArrayList<CommonCompletionProposal> keywords = new ArrayList<CommonCompletionProposal>();
        String prefix = this.fContext.getPartialPrefix();
        String[] stringArray = KEYWORDS;
        int n = KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (keyword.startsWith(prefix)) {
                keywords.add(this.createProposal(keyword, null));
            }
            ++n2;
        }
        return keywords;
    }

    private Collection<? extends ICompletionProposal> suggestSymbols() {
        ArrayList<CommonCompletionProposal> proposals = new ArrayList<CommonCompletionProposal>();
        for (String symbolName : this.fContext.getSymbolsInAST()) {
            CommonCompletionProposal proposal = this.createProposal(":" + symbolName, RubyEditorPlugin.getImage("icons/global_obj.png"));
            proposals.add(proposal);
        }
        return proposals;
    }

    private boolean receiverIsType() {
        String constantName = null;
        String namespace = "";
        String typeName = "";
        Node receiver = this.fContext.getReceiver();
        if (receiver instanceof Colon3Node || receiver instanceof ConstNode) {
            String fullName;
            constantName = fullName = ASTUtils.getFullyQualifiedName((Node)receiver);
            int namespaceIndex = fullName.lastIndexOf(NAMESPACE_DELIMITER);
            if (namespaceIndex != -1) {
                typeName = fullName.substring(0, namespaceIndex);
                constantName = fullName.substring(namespaceIndex + 2);
                namespaceIndex = typeName.lastIndexOf(NAMESPACE_DELIMITER);
                if (namespaceIndex != -1) {
                    namespace = typeName.substring(0, namespaceIndex);
                    typeName = typeName.substring(namespaceIndex + 2);
                }
            }
        } else {
            return false;
        }
        String key = String.valueOf(constantName) + '/' + typeName + '/' + namespace;
        for (Index index : this.allIndicesForProject()) {
            List results;
            if (index == null || (results = index.query(new String[]{"constantDecl"}, key, 8)) == null || results.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private Collection<? extends ICompletionProposal> removeDuplicates(List<ICompletionProposal> proposals, Collection<? extends ICompletionProposal> wordCompletions) {
        if (wordCompletions == null || wordCompletions.isEmpty()) {
            return wordCompletions;
        }
        ArrayList<ICompletionProposal> uniques = new ArrayList<ICompletionProposal>();
        HashSet<String> displayStrings = new HashSet<String>();
        for (ICompletionProposal iCompletionProposal : proposals) {
            displayStrings.add(iCompletionProposal.getDisplayString());
        }
        for (ICompletionProposal iCompletionProposal : wordCompletions) {
            if (displayStrings.contains(iCompletionProposal.getDisplayString())) continue;
            uniques.add(iCompletionProposal);
        }
        return uniques;
    }

    private Collection<? extends ICompletionProposal> suggestTypesInNamespace() {
        ArrayList<CommonCompletionProposal> proposals = new ArrayList<CommonCompletionProposal>();
        String fullPrefix = this.fContext.getFullPrefix();
        String namespace = fullPrefix.substring(0, fullPrefix.lastIndexOf(NAMESPACE_DELIMITER));
        String key = "^[^/]+?/" + namespace + "[^/]*?" + '/' + ".+$";
        HashMap<String, Boolean> proposalToIsClass = new HashMap<String, Boolean>();
        for (Index index : this.allIndicesForProject()) {
            List results;
            if (index == null || (results = index.query(new String[]{"typeDecl"}, key, 24)) == null) continue;
            for (QueryResult result : results) {
                String aNamespace = this.getNamespace(result.getWord());
                if (namespace.equals(aNamespace)) {
                    String typeName = this.getTypeName(result.getWord());
                    proposalToIsClass.put(typeName, true);
                    continue;
                }
                if (!aNamespace.startsWith(fullPrefix)) continue;
                int previousDelim = aNamespace.lastIndexOf(NAMESPACE_DELIMITER, fullPrefix.length());
                previousDelim = previousDelim == -1 ? 0 : (previousDelim += 2);
                int nextDelim = aNamespace.indexOf(NAMESPACE_DELIMITER, fullPrefix.length());
                if (nextDelim == -1) {
                    nextDelim = aNamespace.length();
                }
                String nextSegment = aNamespace.substring(previousDelim, nextDelim);
                proposalToIsClass.put(nextSegment, false);
            }
        }
        for (Map.Entry entry : proposalToIsClass.entrySet()) {
            proposals.add(this.createProposal((String)entry.getKey(), RubyEditorPlugin.getImage((Boolean)entry.getValue() != false ? CLASS_IMAGE : MODULE_IMAGE)));
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> suggestConstantsInNamespace() {
        int lastNS;
        String implicitNamespace;
        ArrayList<CommonCompletionProposal> proposals = new ArrayList<CommonCompletionProposal>();
        String typeName = "Object";
        String namespace = "";
        String fullPrefix = this.fContext.getFullPrefix();
        if (!fullPrefix.startsWith(NAMESPACE_DELIMITER) && (implicitNamespace = this.fContext.getNamespace()).length() > 0) {
            fullPrefix = String.valueOf(implicitNamespace) + NAMESPACE_DELIMITER + fullPrefix;
        }
        if ((lastNS = fullPrefix.lastIndexOf(NAMESPACE_DELIMITER)) > 0) {
            typeName = fullPrefix.substring(0, lastNS);
        }
        if ((lastNS = typeName.lastIndexOf(NAMESPACE_DELIMITER)) > 0) {
            namespace = typeName.substring(0, lastNS);
            typeName = typeName.substring(lastNS + 2);
        }
        StringBuilder builder = new StringBuilder();
        builder.append('^');
        builder.append(this.fContext.getPartialPrefix()).append("[^/]*?");
        builder.append('/');
        builder.append(typeName);
        builder.append('/');
        builder.append(namespace);
        builder.append('$');
        String key = builder.toString();
        for (Index index : this.allIndicesForProject()) {
            List results;
            if (index == null || (results = index.query(new String[]{"constantDecl"}, key, 24)) == null) continue;
            for (QueryResult result : results) {
                String indexKey = result.getWord();
                proposals.add(this.createProposal(indexKey.substring(0, indexKey.indexOf(47)), RubyEditorPlugin.getImage(CONSTANT_IMAGE)));
            }
        }
        return proposals;
    }

    protected void sortByDisplayName(List<ICompletionProposal> proposals) {
        Collections.sort(proposals, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return o1.getDisplayString().compareToIgnoreCase(o2.getDisplayString());
            }
        });
    }

    protected Collection<? extends ICompletionProposal> suggestWordCompletions(ITextViewer viewer, int offset) {
        ICompletionProposal[] hippieProposals = new HippieProposalProcessor().computeCompletionProposals(viewer, offset);
        if (hippieProposals == null || hippieProposals.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(hippieProposals);
    }

    private Collection<? extends ICompletionProposal> suggestLocalVariables() {
        ArrayList<CommonCompletionProposal> proposals = new ArrayList<CommonCompletionProposal>();
        String prefix = this.fContext.getPartialPrefix();
        for (String localName : this.fContext.getLocalsInScope()) {
            if (!localName.startsWith(prefix)) continue;
            CommonCompletionProposal proposal = this.createProposal(localName, RubyEditorPlugin.getImage(LOCAL_VAR_IMAGE));
            proposals.add(proposal);
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> suggestInstanceVariables() {
        ArrayList<CommonCompletionProposal> proposals = new ArrayList<CommonCompletionProposal>();
        Node enclosing = this.fContext.getEnclosingTypeNode();
        List instAssignments = new ScopedNodeLocator().find(enclosing, new INodeAcceptor(){

            public boolean accepts(Node node) {
                return node instanceof InstAsgnNode;
            }
        });
        for (Node assign : instAssignments) {
            String instanceVarName = ASTUtils.getName((Node)assign);
            CommonCompletionProposal proposal = this.createProposal(instanceVarName, RubyEditorPlugin.getImage(INSTANCE_VAR_IMAGE));
            proposals.add(proposal);
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> suggestMethodsForEnclosingType() {
        PerformanceStats stats;
        ArrayList<Object> proposals = new ArrayList<Object>();
        Node enclosing = this.fContext.getEnclosingTypeNode();
        String enclosingTypeName = this.fContext.getEnclosingType();
        boolean includeInstance = false;
        if (enclosing instanceof RootNode) {
            includeInstance = true;
        } else {
            MethodDefNode enclosingMethod = (MethodDefNode)new ClosestSpanningNodeLocator().find(this.fContext.getRootNode(), this.fContext.getOffset(), new INodeAcceptor(){

                public boolean accepts(Node node) {
                    return node instanceof MethodDefNode;
                }
            });
            if (enclosingMethod instanceof DefnNode) {
                includeInstance = true;
            }
        }
        List methodDefNodes = new ScopedNodeLocator().find(enclosing, new INodeAcceptor(){

            public boolean accepts(Node node) {
                return node instanceof MethodDefNode;
            }
        });
        for (Node methodDefNode : methodDefNodes) {
            Node enclosingScopeNode;
            String methodName = ASTUtils.getName((Node)methodDefNode);
            if (!methodName.startsWith(this.fContext.getPartialPrefix()) || !(enclosingScopeNode = new ClosestSpanningNodeLocator().find(this.fContext.getRootNode(), methodDefNode.getPosition().getStartOffset(), new INodeAcceptor(){

                public boolean accepts(Node node) {
                    return node instanceof ClassNode || node instanceof ModuleNode || node instanceof RootNode;
                }
            })).equals(enclosing)) continue;
            CommonCompletionProposal proposal = this.createProposal(methodName, RubyEditorPlugin.getImage(PUBLIC_METHOD_IMAGE), enclosingTypeName);
            proposals.add(proposal);
        }
        HashMap<String, Boolean> allTypes = new HashMap<String, Boolean>();
        allTypes.put(enclosingTypeName, enclosing instanceof ModuleNode);
        if (enclosing instanceof ClassNode) {
            ClassNode classNode = (ClassNode)enclosing;
            Node superNode = classNode.getSuperNode();
            String superTypeName = "Object";
            if (superNode != null) {
                superTypeName = ASTUtils.getFullyQualifiedName((Node)superNode);
            }
            allTypes.put(superTypeName, false);
            PerformanceStats stats2 = null;
            if (PerformanceStats.isEnabled((String)CALC_SUPER_TYPE_EVENT)) {
                stats2 = PerformanceStats.getStats((String)CALC_SUPER_TYPE_EVENT, (Object)((Object)this));
                stats2.startRun(superTypeName);
            }
            allTypes.putAll(this.calculateSuperTypes(superTypeName));
            if (stats2 != null) {
                stats2.endRun();
                stats2 = null;
            }
        } else {
            stats = null;
            if (PerformanceStats.isEnabled((String)CALC_SUPER_TYPE_EVENT)) {
                stats = PerformanceStats.getStats((String)CALC_SUPER_TYPE_EVENT, (Object)((Object)this));
                stats.startRun(enclosingTypeName);
            }
            allTypes.putAll(this.calculateSuperTypes(enclosingTypeName));
            if (stats != null) {
                stats.endRun();
                stats = null;
            }
        }
        stats = null;
        if (PerformanceStats.isEnabled((String)METHOD_PROPOSALS_FOR_TYPE_EVENT)) {
            stats = PerformanceStats.getStats((String)METHOD_PROPOSALS_FOR_TYPE_EVENT, (Object)((Object)this));
            stats.startRun(((Object)allTypes).toString());
        }
        HashSet<String> receiverTypes = new HashSet<String>();
        receiverTypes.add(enclosingTypeName);
        proposals.addAll(this.suggestMethodsForTypes(receiverTypes, allTypes, !includeInstance, includeInstance, true, true));
        if (stats != null) {
            stats.endRun();
            stats = null;
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> suggestMethodsForTypes(Set<String> receiverTypes, Map<String, Boolean> typeNames, boolean includeSingleton, boolean includeInstance, boolean includeProtected, boolean includePrivate) {
        ArrayList<CommonCompletionProposal> proposals = new ArrayList<CommonCompletionProposal>();
        HashSet<String> possibles = new HashSet<String>();
        for (String typeName : typeNames.keySet()) {
            Object simpleName = typeName;
            String namespace = "";
            int lastDelim = typeName.lastIndexOf(NAMESPACE_DELIMITER);
            if (lastDelim != -1) {
                namespace = typeName.substring(0, lastDelim);
                simpleName = typeName.substring(lastDelim + 2);
            }
            possibles.add(String.valueOf(simpleName) + '/' + namespace);
        }
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append('^');
        keyBuilder.append(this.fContext.getPartialPrefix());
        keyBuilder.append("[^/]*?");
        keyBuilder.append('/');
        keyBuilder.append('(');
        for (String possible : possibles) {
            keyBuilder.append(possible);
            keyBuilder.append('|');
        }
        keyBuilder.deleteCharAt(keyBuilder.length() - 1);
        keyBuilder.append(')');
        keyBuilder.append('/');
        keyBuilder.append("(P");
        if (includeProtected) {
            keyBuilder.append("|R");
        }
        if (includePrivate) {
            keyBuilder.append("|V");
        }
        keyBuilder.append(')');
        keyBuilder.append('/');
        if (includeInstance && includeSingleton) {
            keyBuilder.append("(S|I)");
        } else if (includeInstance) {
            keyBuilder.append('I');
        } else if (includeSingleton) {
            keyBuilder.append('S');
        }
        keyBuilder.append('/');
        keyBuilder.append("[^/]*$");
        String key = keyBuilder.toString();
        for (Index index : this.allIndicesForProject()) {
            List results;
            if (index == null || (results = index.query(new String[]{"methodDecl"}, key, 24)) == null) continue;
            for (QueryResult result : results) {
                Image image;
                String typeNameInKey = this.getTypeNameFromMethodDefKey(result.getWord());
                if (includeSingleton) {
                    boolean isModule = typeNames.get(typeNameInKey);
                    boolean isSingletonMethod = this.isSingletonMethodInKey(result.getWord());
                    if (isSingletonMethod && isModule && !receiverTypes.contains(typeNameInKey)) continue;
                }
                String methodName = this.getMethodNameFromMethodDefKey(result.getWord());
                IRubyMethod.Visibility vis = this.getVisibilityFromMethodDefKey(result.getWord());
                switch (vis) {
                    case PRIVATE: {
                        image = RubyEditorPlugin.getImage(PRIVATE_METHOD_IMAGE);
                        break;
                    }
                    case PROTECTED: {
                        image = RubyEditorPlugin.getImage(PROTECTED_METHOD_IMAGE);
                        break;
                    }
                    default: {
                        image = RubyEditorPlugin.getImage(PUBLIC_METHOD_IMAGE);
                    }
                }
                proposals.add(this.createProposal(methodName, image, typeNameInKey));
            }
        }
        return proposals;
    }

    private boolean isSingletonMethodInKey(String word) {
        String[] parts = word.split(Character.toString('/'));
        String singletonOrInstance = parts[4];
        if (singletonOrInstance != null && singletonOrInstance.length() > 0) {
            char c = singletonOrInstance.charAt(0);
            switch (c) {
                case 'S': {
                    return true;
                }
                case 'I': {
                    return false;
                }
            }
        }
        return false;
    }

    protected Collection<Index> allIndicesForProject() {
        return RubyIndexUtil.allIndices((IProject)this.getProject());
    }

    private IRubyMethod.Visibility getVisibilityFromMethodDefKey(String word) {
        String[] parts = word.split(Character.toString('/'));
        String namespace = parts[3];
        if (namespace != null && namespace.length() > 0) {
            char c = namespace.charAt(0);
            switch (c) {
                case 'P': {
                    return IRubyMethod.Visibility.PUBLIC;
                }
                case 'R': {
                    return IRubyMethod.Visibility.PROTECTED;
                }
                case 'V': {
                    return IRubyMethod.Visibility.PRIVATE;
                }
            }
        }
        return IRubyMethod.Visibility.PUBLIC;
    }

    private String getTypeNameFromMethodDefKey(String word) {
        String[] parts = word.split(Character.toString('/'));
        String simpleName = parts[1];
        String namespace = parts[2];
        if (namespace != null && namespace.length() > 0) {
            return String.valueOf(namespace) + NAMESPACE_DELIMITER + simpleName;
        }
        return simpleName;
    }

    private String getMethodNameFromMethodDefKey(String word) {
        return word.substring(0, word.indexOf(47));
    }

    private void trace(String format) {
    }

    private Collection<? extends ICompletionProposal> suggestClassVariables() {
        ArrayList<CommonCompletionProposal> proposals = new ArrayList<CommonCompletionProposal>();
        Node enclosing = this.fContext.getEnclosingTypeNode();
        List assignments = new ScopedNodeLocator().find(enclosing, new INodeAcceptor(){

            public boolean accepts(Node node) {
                return node instanceof ClassVarAsgnNode || node instanceof ClassVarDeclNode;
            }
        });
        for (Node assign : assignments) {
            String varName = ASTUtils.getName((Node)assign);
            CommonCompletionProposal proposal = this.createProposal(varName, RubyEditorPlugin.getImage(CLASS_VAR_IMAGE));
            proposals.add(proposal);
        }
        return proposals;
    }

    private List<ICompletionProposal> suggestGlobals() {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        TreeSet<String> globalNames = new TreeSet<String>();
        for (Index index : this.allIndicesForProject()) {
            if (index == null) continue;
            List results = index.query(new String[]{"globalDecl"}, this.fContext.getPartialPrefix(), 9);
            if (results == null) continue;
            for (QueryResult result : results) {
                globalNames.add(result.getWord());
            }
        }
        for (String globalName : globalNames) {
            CommonCompletionProposal proposal = this.createProposal(globalName, RubyEditorPlugin.getImage("icons/global_obj.png"));
            proposals.add((ICompletionProposal)proposal);
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> suggestTypeNames() {
        ArrayList<CommonCompletionProposal> proposals = new ArrayList<CommonCompletionProposal>();
        TreeSet<String> typeKeys = new TreeSet<String>();
        for (Index index : this.allIndicesForProject()) {
            List results;
            if (index == null || (results = index.query(new String[]{"typeDecl"}, this.fContext.getPartialPrefix(), 9)) == null) continue;
            for (QueryResult result : results) {
                typeKeys.add(result.getWord());
            }
        }
        for (String typeKey : typeKeys) {
            String typeName = this.getTypeName(typeKey);
            Image image = this.isClass(typeKey) ? RubyEditorPlugin.getImage(CLASS_IMAGE) : RubyEditorPlugin.getImage(MODULE_IMAGE);
            CommonCompletionProposal proposal = this.createProposal(typeName, image);
            proposals.add(proposal);
        }
        return proposals;
    }

    private boolean isClass(String typeKey) {
        return typeKey.charAt(typeKey.length() - 1) == 'C';
    }

    private String getTypeName(String typeKey) {
        return new String(typeKey.substring(0, typeKey.indexOf(47)));
    }

    private String getNamespace(String typeKey) {
        int firstSep = typeKey.indexOf(47);
        return new String(typeKey.substring(firstSep + 1, typeKey.indexOf(47, firstSep + 1)));
    }

    protected CommonCompletionProposal createProposal(String name, Image image) {
        return this.createProposal(name, image, null);
    }

    protected CommonCompletionProposal createProposal(String name, Image image, String location) {
        CommonCompletionProposal proposal = new CommonCompletionProposal(name, this.fContext.getReplaceStart(), this.fContext.getPartialPrefix().length(), name.length(), image, name, null, null);
        if (location != null) {
            proposal.setFileLocation(location);
        }
        proposal.setTriggerCharacters(this.getProposalTriggerCharacters());
        return proposal;
    }

    private Map<String, Boolean> calculateSuperTypes(String typeName) {
        HashMap<String, Boolean> typeNames = new HashMap<String, Boolean>();
        if (typeName == null) {
            return typeNames;
        }
        if ("Object".equals(typeName)) {
            typeNames.put("Kernel", true);
            return typeNames;
        }
        String simpleName = typeName;
        String namespace = "";
        int lastDelim = typeName.lastIndexOf(NAMESPACE_DELIMITER);
        if (lastDelim != -1) {
            namespace = typeName.substring(0, lastDelim);
            simpleName = typeName.substring(lastDelim + 2);
        }
        HashMap<String, Boolean> moduleNames = new HashMap<String, Boolean>();
        String key = "^[^/]*/[^/]*/" + simpleName + '/' + namespace + '/' + ".*$";
        for (Index index : this.allIndicesForProject()) {
            if (index == null) continue;
            List results = index.query(new String[]{"superRef"}, key, 24);
            if (results == null) continue;
            for (QueryResult result : results) {
                char classOrModule = result.getWord().charAt(result.getWord().length() - 2);
                if ('M' == classOrModule) {
                    moduleNames.put(this.getTypeNameFromSuperRefKey(result.getWord()), true);
                    continue;
                }
                typeNames.put(this.getTypeNameFromSuperRefKey(result.getWord()), false);
            }
        }
        this.trace(MessageFormat.format("Supertypes of {0}: {1}", typeName, typeNames));
        this.trace(MessageFormat.format("Included modules: {0}", moduleNames));
        HashMap<String, Boolean> typeNamesCopy = new HashMap<String, Boolean>(typeNames);
        for (String superType : typeNamesCopy.keySet()) {
            typeNames.putAll(this.calculateSuperTypes(superType));
        }
        typeNames.putAll(moduleNames);
        return typeNames;
    }

    private String getTypeNameFromSuperRefKey(String superRefKey) {
        int firstSep = superRefKey.indexOf(47);
        String simpleName = superRefKey.substring(0, firstSep);
        String namespace = superRefKey.substring(firstSep + 1, superRefKey.indexOf(47, firstSep + 1));
        if (namespace.length() == 0) {
            return simpleName;
        }
        return String.valueOf(namespace) + NAMESPACE_DELIMITER + simpleName;
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.ruby";
    }

    protected void sortProposals(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, CompletionProposalComparator.descending((Comparator)CompletionProposalComparator.getComparator((CompletionProposalComparator[])new CompletionProposalComparator[]{CompletionProposalComparator.NameSort, CompletionProposalComparator.TemplateSort})));
    }
}

